/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.crafting;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.IntSupplier;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import org.zeith.hammerlib.api.crafting.AbstractRecipeRegistry;
import org.zeith.hammerlib.api.crafting.IGeneralRecipe;
import org.zeith.hammerlib.api.crafting.IRecipeContainer;

public class IndexedRecipeRegistry<T extends IGeneralRecipe>
extends AbstractRecipeRegistry<T, IndexedRecipeContainer<T>, IntSupplier> {
    public IndexedRecipeRegistry(Class<T> type, ResourceLocation id) {
        super(type, new IndexedRecipeContainer<T>(type), id);
    }

    @Override
    public IntSupplier addRecipe(T recipe) {
        AtomicInteger id = ((IndexedRecipeContainer)this.container).register(recipe);
        return id::get;
    }

    @Override
    public void removeRecipe(T recipe) {
        ((IndexedRecipeContainer)this.container).unregister(recipe);
    }

    @Override
    protected void removeAllRecipes() {
        ((IndexedRecipeContainer)this.container).removeAllRecipes();
    }

    @Override
    public T getRecipe(IntSupplier identifier) {
        return this.getRecipe(identifier.getAsInt());
    }

    @Override
    @Nullable
    public T getRecipe(int id) {
        if (((IndexedRecipeContainer)this.container).elements.size() > id) {
            return (T)((IGeneralRecipe)((IndexedRecipeContainer)this.container).elements.get(id));
        }
        return null;
    }

    protected static class IndexedRecipeContainer<T extends IGeneralRecipe>
    implements IRecipeContainer<T> {
        private final Class<T> type;
        private final List<T> elements = new ArrayList<T>();
        private final List<T> elementView = Collections.unmodifiableList(this.elements);
        private final BiMap<AtomicInteger, T> indices = HashBiMap.create();
        private final BiMap<T, AtomicInteger> indicesInv = this.indices.inverse();

        public IndexedRecipeContainer(Class<T> type) {
            this.type = type;
        }

        public AtomicInteger register(T elem) {
            Objects.requireNonNull(elem, "Recipe element must not be null!");
            AtomicInteger id = new AtomicInteger(this.elements.size());
            this.elements.add(elem);
            this.indices.put((Object)id, elem);
            return id;
        }

        public boolean unregister(T elem) {
            if (elem != null && this.elements.contains(elem)) {
                this.elements.remove(elem);
                this.sort();
                return true;
            }
            return false;
        }

        public void sort() {
            this.indices.values().removeIf(e -> !this.elements.contains(e));
            for (int i = 0; i < this.elements.size(); ++i) {
                IGeneralRecipe e2 = (IGeneralRecipe)this.elements.get(i);
                if (!this.indices.containsValue((Object)e2)) {
                    this.indices.put((Object)new AtomicInteger(i), (Object)e2);
                    continue;
                }
                ((AtomicInteger)this.indicesInv.get((Object)e2)).set(i);
            }
        }

        void removeAllRecipes() {
            this.elements.clear();
            this.indices.clear();
        }

        @Override
        public Collection<T> getRecipes() {
            return this.elementView;
        }

        @Override
        public Class<T> getType() {
            return this.type;
        }
    }
}

